#include "core.h"
#include "process.h"
#include "master.h"
#include "dbmonitor/db32100.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "dbmon.h"
#include "mac32core.h"
#include "mac32dbmon.h"
SRCFILE("mac32dbmon.c")

char *Mac32DbmonMaster::proctype()	{ return "32100"; }

Process	*Mac32DbmonMaster::newProcess(Process *pr, char *p, char *s, char* c)
{
	return new Mac32DbmonProcess(fd, boardid, pipeid, pr, p, s, c);
}

Mac32DbmonProcess::Mac32DbmonProcess(int f, int b, int pid, Process *sib,
  char *p, char *s, char *c) : DbmonProcess(f, b, pid, sib, p, s, c) {}


Core *Mac32DbmonProcess::newCore(int f, int b, int p, Master *m)
{
	return new Mac32DbmonCore(f, b, p, this, m);
}

Mac32DbmonCore::Mac32DbmonCore(int f, int b, int p, Process *pr, Master *m):
  Core(pr,m), DbmonCore(f,b,p)
{
	regsize = sizeof(DebugRegs);
}
